/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.org.jvnet.mimepull.Header;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEMessage;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEPart;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentEx;
import com.sun.xml.internal.ws.developer.StreamingAttachmentFeature;
import com.sun.xml.internal.ws.developer.StreamingDataHandler;
import com.sun.xml.internal.ws.encoding.ContentTypeImpl;
import com.sun.xml.internal.ws.encoding.DataSourceStreamingDataHandler;
import com.sun.xml.internal.ws.encoding.MIMEPartStreamingDataHandler;
import com.sun.xml.internal.ws.util.ByteArrayBuffer;
import com.sun.xml.internal.ws.util.ByteArrayDataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;

public final class MimeMultipartParser {
    private final String start;
    private final MIMEMessage message;
    private Attachment root;
    private ContentTypeImpl contentType;
    private final Map<String, Attachment> attachments = new HashMap<String, Attachment>();
    private boolean gotAll;

    public MimeMultipartParser(InputStream inputStream, String string, StreamingAttachmentFeature streamingAttachmentFeature) {
        this.contentType = new ContentTypeImpl(string);
        String string2 = this.contentType.getBoundary();
        if (string2 == null || string2.equals("")) {
            throw new WebServiceException("MIME boundary parameter not found" + this.contentType);
        }
        this.message = streamingAttachmentFeature != null ? new MIMEMessage(inputStream, string2, streamingAttachmentFeature.getConfig()) : new MIMEMessage(inputStream, string2);
        String string3 = this.contentType.getRootId();
        if (string3 != null && string3.length() > 2 && string3.charAt(0) == '<' && string3.charAt(string3.length() - 1) == '>') {
            string3 = string3.substring(1, string3.length() - 1);
        }
        this.start = string3;
    }

    @Nullable
    public Attachment getRootPart() {
        if (this.root == null) {
            this.root = new PartAttachment(this.start != null ? this.message.getPart(this.start) : this.message.getPart(0));
        }
        return this.root;
    }

    @NotNull
    public Map<String, Attachment> getAttachmentParts() {
        if (!this.gotAll) {
            MIMEPart mIMEPart = this.start != null ? this.message.getPart(this.start) : this.message.getPart(0);
            List<MIMEPart> list = this.message.getAttachments();
            for (MIMEPart mIMEPart2 : list) {
                String string;
                if (mIMEPart2 == mIMEPart || this.attachments.containsKey(string = mIMEPart2.getContentId())) continue;
                PartAttachment partAttachment = new PartAttachment(mIMEPart2);
                this.attachments.put(partAttachment.getContentId(), partAttachment);
            }
            this.gotAll = true;
        }
        return this.attachments;
    }

    @Nullable
    public Attachment getAttachmentPart(String string) throws IOException {
        Attachment attachment = this.attachments.get(string);
        if (attachment == null) {
            MIMEPart mIMEPart = this.message.getPart(string);
            attachment = new PartAttachment(mIMEPart);
            this.attachments.put(string, attachment);
        }
        return attachment;
    }

    public ContentTypeImpl getContentType() {
        return this.contentType;
    }

    static class PartAttachment
    implements AttachmentEx {
        final MIMEPart part;
        byte[] buf;
        private StreamingDataHandler streamingDataHandler;

        PartAttachment(MIMEPart mIMEPart) {
            this.part = mIMEPart;
        }

        @Override
        @NotNull
        public String getContentId() {
            return this.part.getContentId();
        }

        @Override
        @NotNull
        public String getContentType() {
            return this.part.getContentType();
        }

        @Override
        public byte[] asByteArray() {
            if (this.buf == null) {
                ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer();
                try {
                    byteArrayBuffer.write(this.part.readOnce());
                }
                catch (IOException iOException) {
                    throw new WebServiceException(iOException);
                }
                finally {
                    if (byteArrayBuffer != null) {
                        try {
                            byteArrayBuffer.close();
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(MimeMultipartParser.class.getName()).log(Level.FINE, null, iOException);
                        }
                    }
                }
                this.buf = byteArrayBuffer.toByteArray();
            }
            return this.buf;
        }

        @Override
        public DataHandler asDataHandler() {
            if (this.streamingDataHandler == null) {
                this.streamingDataHandler = this.buf != null ? new DataSourceStreamingDataHandler(new ByteArrayDataSource(this.buf, this.getContentType())) : new MIMEPartStreamingDataHandler(this.part);
            }
            return this.streamingDataHandler;
        }

        @Override
        public Source asSource() {
            return this.buf != null ? new StreamSource(new ByteArrayInputStream(this.buf)) : new StreamSource(this.part.read());
        }

        @Override
        public InputStream asInputStream() {
            return this.buf != null ? new ByteArrayInputStream(this.buf) : this.part.read();
        }

        @Override
        public void writeTo(OutputStream outputStream) throws IOException {
            if (this.buf != null) {
                outputStream.write(this.buf);
            } else {
                int n;
                InputStream inputStream = this.part.read();
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
                inputStream.close();
            }
        }

        @Override
        public void writeTo(SOAPMessage sOAPMessage) throws SOAPException {
            sOAPMessage.createAttachmentPart().setDataHandler(this.asDataHandler());
        }

        @Override
        public Iterator<AttachmentEx.MimeHeader> getMimeHeaders() {
            final Iterator<? extends Header> iterator = this.part.getAllHeaders().iterator();
            return new Iterator<AttachmentEx.MimeHeader>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public AttachmentEx.MimeHeader next() {
                    final Header header = (Header)iterator.next();
                    return new AttachmentEx.MimeHeader(){

                        @Override
                        public String getValue() {
                            return header.getValue();
                        }

                        @Override
                        public String getName() {
                            return header.getName();
                        }
                    };
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

