/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.oracle.webservices.internal.api.databinding.ExternalMetadataFeature;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.Closeable;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.ComponentFeature;
import com.sun.xml.internal.ws.api.ComponentsFeature;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.WSService;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.client.ServiceInterceptor;
import com.sun.xml.internal.ws.api.client.ServiceInterceptorFactory;
import com.sun.xml.internal.ws.api.client.WSPortInfo;
import com.sun.xml.internal.ws.api.databinding.DatabindingConfig;
import com.sun.xml.internal.ws.api.databinding.DatabindingFactory;
import com.sun.xml.internal.ws.api.databinding.MetadataReader;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLService;
import com.sun.xml.internal.ws.api.pipe.Stubs;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.ContainerResolver;
import com.sun.xml.internal.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.client.ClientContainer;
import com.sun.xml.internal.ws.client.HandlerConfigurator;
import com.sun.xml.internal.ws.client.PortInfo;
import com.sun.xml.internal.ws.client.SEIPortInfo;
import com.sun.xml.internal.ws.client.sei.SEIStub;
import com.sun.xml.internal.ws.db.DatabindingImpl;
import com.sun.xml.internal.ws.developer.MemberSubmissionAddressingFeature;
import com.sun.xml.internal.ws.developer.UsesJAXBContextFeature;
import com.sun.xml.internal.ws.developer.WSBindingProvider;
import com.sun.xml.internal.ws.model.RuntimeModeler;
import com.sun.xml.internal.ws.model.SOAPSEIModel;
import com.sun.xml.internal.ws.resources.ClientMessages;
import com.sun.xml.internal.ws.resources.DispatchMessages;
import com.sun.xml.internal.ws.resources.ProviderApiMessages;
import com.sun.xml.internal.ws.util.JAXWSUtils;
import com.sun.xml.internal.ws.util.ServiceConfigurationError;
import com.sun.xml.internal.ws.util.ServiceFinder;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import com.sun.xml.internal.ws.wsdl.parser.RuntimeWSDLParser;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.soap.AddressingFeature;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class WSServiceDelegate
extends WSService {
    private final Map<QName, PortInfo> ports = new HashMap<QName, PortInfo>();
    @NotNull
    private HandlerConfigurator handlerConfigurator = new HandlerConfigurator.HandlerResolverImpl(null);
    private final Class<? extends Service> serviceClass;
    private final WebServiceFeatureList features;
    @NotNull
    private final QName serviceName;
    private final Map<QName, SEIPortInfo> seiContext = new HashMap<QName, SEIPortInfo>();
    private volatile Executor executor;
    @Nullable
    private WSDLService wsdlService;
    private final Container container;
    @NotNull
    final ServiceInterceptor serviceInterceptor;
    private URL wsdlURL;
    protected static final WebServiceFeature[] EMPTY_FEATURES = new WebServiceFeature[0];

    protected Map<QName, PortInfo> getQNameToPortInfoMap() {
        return this.ports;
    }

    public WSServiceDelegate(URL uRL, QName qName, Class<? extends Service> clazz, WebServiceFeature ... webServiceFeatureArray) {
        this(uRL, qName, clazz, new WebServiceFeatureList(webServiceFeatureArray));
    }

    protected WSServiceDelegate(URL uRL, QName qName, Class<? extends Service> clazz, WebServiceFeatureList webServiceFeatureList) {
        this((Source)(uRL == null ? null : new StreamSource(uRL.toExternalForm())), qName, clazz, webServiceFeatureList);
        this.wsdlURL = uRL;
    }

    public WSServiceDelegate(@Nullable Source source, @NotNull QName qName, @NotNull Class<? extends Service> clazz, WebServiceFeature ... webServiceFeatureArray) {
        this(source, qName, clazz, new WebServiceFeatureList(webServiceFeatureArray));
    }

    protected WSServiceDelegate(@Nullable Source source, @NotNull QName qName, @NotNull Class<? extends Service> clazz, WebServiceFeatureList webServiceFeatureList) {
        this(source, null, qName, clazz, webServiceFeatureList);
    }

    public WSServiceDelegate(@Nullable Source source, @Nullable WSDLService wSDLService, @NotNull QName qName, @NotNull Class<? extends Service> clazz, WebServiceFeature ... webServiceFeatureArray) {
        this(source, wSDLService, qName, clazz, new WebServiceFeatureList(webServiceFeatureArray));
    }

    public WSServiceDelegate(@Nullable Source source, @Nullable WSDLService wSDLService, @NotNull QName qName, final @NotNull Class<? extends Service> clazz, WebServiceFeatureList webServiceFeatureList) {
        Object malformedURLException;
        ComponentsFeature componentsFeature;
        Container container;
        if (qName == null) {
            throw new WebServiceException(ClientMessages.INVALID_SERVICE_NAME_NULL(null));
        }
        this.features = webServiceFeatureList;
        WSService.InitParams initParams = (WSService.InitParams)INIT_PARAMS.get();
        INIT_PARAMS.set(null);
        if (initParams == null) {
            initParams = EMPTY_PARAMS;
        }
        this.serviceName = qName;
        this.serviceClass = clazz;
        Container container2 = container = initParams.getContainer() != null ? initParams.getContainer() : ContainerResolver.getInstance().getContainer();
        if (container == Container.NONE) {
            container = new ClientContainer();
        }
        this.container = container;
        ComponentFeature componentFeature = this.features.get(ComponentFeature.class);
        if (componentFeature != null) {
            switch (componentFeature.getTarget()) {
                case SERVICE: {
                    this.getComponents().add(componentFeature.getComponent());
                    break;
                }
                case CONTAINER: {
                    this.container.getComponents().add(componentFeature.getComponent());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        if ((componentsFeature = this.features.get(ComponentsFeature.class)) != null) {
            block10: for (ComponentFeature object22 : componentsFeature.getComponentFeatures()) {
                switch (object22.getTarget()) {
                    case SERVICE: {
                        this.getComponents().add(object22.getComponent());
                        continue block10;
                    }
                    case CONTAINER: {
                        this.container.getComponents().add(object22.getComponent());
                        continue block10;
                    }
                }
                throw new IllegalArgumentException();
            }
        }
        Object object3 = ServiceInterceptorFactory.load(this, Thread.currentThread().getContextClassLoader());
        ServiceInterceptor serviceInterceptor = this.container.getSPI(ServiceInterceptor.class);
        if (serviceInterceptor != null) {
            object3 = ServiceInterceptor.aggregate(new ServiceInterceptor[]{object3, serviceInterceptor});
        }
        this.serviceInterceptor = object3;
        if (wSDLService == null) {
            Object wSDLPort;
            if (source == null && clazz != Service.class) {
                malformedURLException = AccessController.doPrivileged(new PrivilegedAction<WebServiceClient>(){

                    @Override
                    public WebServiceClient run() {
                        return clazz.getAnnotation(WebServiceClient.class);
                    }
                });
                wSDLPort = malformedURLException.wsdlLocation();
                wSDLPort = JAXWSUtils.absolutize(JAXWSUtils.getFileOrURLName((String)wSDLPort));
                source = new StreamSource((String)wSDLPort);
            }
            if (source != null) {
                try {
                    malformedURLException = source.getSystemId() == null ? null : JAXWSUtils.getEncodedURL(source.getSystemId());
                    wSDLPort = this.parseWSDL((URL)malformedURLException, source, clazz);
                    wSDLService = wSDLPort.getService(this.serviceName);
                    if (wSDLService == null) {
                        throw new WebServiceException(ClientMessages.INVALID_SERVICE_NAME(this.serviceName, this.buildNameList(wSDLPort.getServices().keySet())));
                    }
                    for (WSDLPort wSDLPort2 : wSDLService.getPorts()) {
                        this.ports.put(wSDLPort2.getName(), new PortInfo(this, wSDLPort2));
                    }
                }
                catch (MalformedURLException malformedURLException2) {
                    throw new WebServiceException(ClientMessages.INVALID_WSDL_URL(source.getSystemId()));
                }
            }
        } else {
            malformedURLException = wSDLService.getPorts().iterator();
            while (malformedURLException.hasNext()) {
                WSDLPort wSDLPort = malformedURLException.next();
                this.ports.put(wSDLPort.getName(), new PortInfo(this, wSDLPort));
            }
        }
        this.wsdlService = wSDLService;
        if (clazz != Service.class && (malformedURLException = AccessController.doPrivileged(new PrivilegedAction<HandlerChain>(){

            @Override
            public HandlerChain run() {
                return clazz.getAnnotation(HandlerChain.class);
            }
        })) != null) {
            this.handlerConfigurator = new HandlerConfigurator.AnnotationConfigurator(this);
        }
    }

    private WSDLModel parseWSDL(URL uRL, Source source, Class clazz) {
        try {
            return RuntimeWSDLParser.parse(uRL, source, this.createCatalogResolver(), true, this.getContainer(), clazz, ServiceFinder.find(WSDLParserExtension.class).toArray());
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
        catch (SAXException sAXException) {
            throw new WebServiceException(sAXException);
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            throw new WebServiceException(serviceConfigurationError);
        }
    }

    protected EntityResolver createCatalogResolver() {
        return XmlUtil.createDefaultCatalogResolver();
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public HandlerResolver getHandlerResolver() {
        return this.handlerConfigurator.getResolver();
    }

    final HandlerConfigurator getHandlerConfigurator() {
        return this.handlerConfigurator;
    }

    @Override
    public void setHandlerResolver(HandlerResolver handlerResolver) {
        this.handlerConfigurator = new HandlerConfigurator.HandlerResolverImpl(handlerResolver);
    }

    @Override
    public <T> T getPort(QName qName, Class<T> clazz) throws WebServiceException {
        return this.getPort(qName, clazz, EMPTY_FEATURES);
    }

    @Override
    public <T> T getPort(QName qName, Class<T> clazz, WebServiceFeature ... webServiceFeatureArray) {
        if (qName == null || clazz == null) {
            throw new IllegalArgumentException();
        }
        WSDLService wSDLService = this.wsdlService;
        if (wSDLService == null && (wSDLService = this.getWSDLModelfromSEI(clazz)) == null) {
            throw new WebServiceException(ProviderApiMessages.NO_WSDL_NO_PORT(clazz.getName()));
        }
        WSDLPort wSDLPort = this.getPortModel(wSDLService, qName);
        return this.getPort(wSDLPort.getEPR(), qName, clazz, new WebServiceFeatureList(webServiceFeatureArray));
    }

    @Override
    public <T> T getPort(EndpointReference endpointReference, Class<T> clazz, WebServiceFeature ... webServiceFeatureArray) {
        return this.getPort(WSEndpointReference.create(endpointReference), clazz, webServiceFeatureArray);
    }

    @Override
    public <T> T getPort(WSEndpointReference wSEndpointReference, Class<T> clazz, WebServiceFeature ... webServiceFeatureArray) {
        WebServiceFeatureList webServiceFeatureList = new WebServiceFeatureList(webServiceFeatureArray);
        QName qName = RuntimeModeler.getPortTypeName(clazz, this.getMetadadaReader(webServiceFeatureList, clazz.getClassLoader()));
        QName qName2 = this.getPortNameFromEPR(wSEndpointReference, qName);
        return this.getPort(wSEndpointReference, qName2, clazz, webServiceFeatureList);
    }

    protected <T> T getPort(WSEndpointReference wSEndpointReference, QName qName, Class<T> clazz, WebServiceFeatureList webServiceFeatureList) {
        ComponentFeature componentFeature = webServiceFeatureList.get(ComponentFeature.class);
        if (componentFeature != null && !ComponentFeature.Target.STUB.equals((Object)componentFeature.getTarget())) {
            throw new IllegalArgumentException();
        }
        ComponentsFeature componentsFeature = webServiceFeatureList.get(ComponentsFeature.class);
        if (componentsFeature != null) {
            for (ComponentFeature componentFeature2 : componentsFeature.getComponentFeatures()) {
                if (ComponentFeature.Target.STUB.equals((Object)componentFeature2.getTarget())) continue;
                throw new IllegalArgumentException();
            }
        }
        webServiceFeatureList.addAll(this.features);
        SEIPortInfo sEIPortInfo = this.addSEI(qName, clazz, webServiceFeatureList);
        return this.createEndpointIFBaseProxy(wSEndpointReference, qName, clazz, webServiceFeatureList, sEIPortInfo);
    }

    @Override
    public <T> T getPort(Class<T> clazz, WebServiceFeature ... webServiceFeatureArray) {
        QName qName = RuntimeModeler.getPortTypeName(clazz, this.getMetadadaReader(new WebServiceFeatureList(webServiceFeatureArray), clazz.getClassLoader()));
        WSDLService wSDLService = this.wsdlService;
        if (wSDLService == null && (wSDLService = this.getWSDLModelfromSEI(clazz)) == null) {
            throw new WebServiceException(ProviderApiMessages.NO_WSDL_NO_PORT(clazz.getName()));
        }
        WSDLPort wSDLPort = wSDLService.getMatchingPort(qName);
        if (wSDLPort == null) {
            throw new WebServiceException(ClientMessages.UNDEFINED_PORT_TYPE(qName));
        }
        QName qName2 = wSDLPort.getName();
        return this.getPort(qName2, clazz, webServiceFeatureArray);
    }

    @Override
    public <T> T getPort(Class<T> clazz) throws WebServiceException {
        return this.getPort(clazz, EMPTY_FEATURES);
    }

    @Override
    public void addPort(QName qName, String string, String string2) throws WebServiceException {
        if (this.ports.containsKey(qName)) {
            throw new WebServiceException(DispatchMessages.DUPLICATE_PORT(qName.toString()));
        }
        BindingID bindingID = string == null ? BindingID.SOAP11_HTTP : BindingID.parse(string);
        this.ports.put(qName, new PortInfo(this, string2 == null ? null : EndpointAddress.create(string2), qName, bindingID));
    }

    @Override
    public <T> Dispatch<T> createDispatch(QName qName, Class<T> clazz, Service.Mode mode) throws WebServiceException {
        return this.createDispatch(qName, clazz, mode, EMPTY_FEATURES);
    }

    @Override
    public <T> Dispatch<T> createDispatch(QName qName, WSEndpointReference wSEndpointReference, Class<T> clazz, Service.Mode mode, WebServiceFeature ... webServiceFeatureArray) {
        return this.createDispatch(qName, wSEndpointReference, clazz, mode, new WebServiceFeatureList(webServiceFeatureArray));
    }

    public <T> Dispatch<T> createDispatch(QName qName, WSEndpointReference wSEndpointReference, Class<T> clazz, Service.Mode mode, WebServiceFeatureList webServiceFeatureList) {
        PortInfo portInfo = this.safeGetPort(qName);
        ComponentFeature componentFeature = webServiceFeatureList.get(ComponentFeature.class);
        if (componentFeature != null && !ComponentFeature.Target.STUB.equals((Object)componentFeature.getTarget())) {
            throw new IllegalArgumentException();
        }
        ComponentsFeature componentsFeature = webServiceFeatureList.get(ComponentsFeature.class);
        if (componentsFeature != null) {
            for (ComponentFeature object2 : componentsFeature.getComponentFeatures()) {
                if (ComponentFeature.Target.STUB.equals((Object)object2.getTarget())) continue;
                throw new IllegalArgumentException();
            }
        }
        webServiceFeatureList.addAll(this.features);
        BindingImpl bindingImpl = portInfo.createBinding(webServiceFeatureList, null, null);
        bindingImpl.setMode(mode);
        Dispatch<T> dispatch = Stubs.createDispatch(portInfo, this, bindingImpl, clazz, mode, wSEndpointReference);
        this.serviceInterceptor.postCreateDispatch((WSBindingProvider)((Object)dispatch));
        return dispatch;
    }

    @Override
    public <T> Dispatch<T> createDispatch(QName qName, Class<T> clazz, Service.Mode mode, WebServiceFeature ... webServiceFeatureArray) {
        return this.createDispatch(qName, clazz, mode, new WebServiceFeatureList(webServiceFeatureArray));
    }

    public <T> Dispatch<T> createDispatch(QName qName, Class<T> clazz, Service.Mode mode, WebServiceFeatureList webServiceFeatureList) {
        MemberSubmissionAddressingFeature memberSubmissionAddressingFeature;
        WSEndpointReference wSEndpointReference = null;
        boolean bl = false;
        AddressingFeature addressingFeature = webServiceFeatureList.get(AddressingFeature.class);
        if (addressingFeature == null) {
            addressingFeature = this.features.get(AddressingFeature.class);
        }
        if (addressingFeature != null && addressingFeature.isEnabled()) {
            bl = true;
        }
        if ((memberSubmissionAddressingFeature = webServiceFeatureList.get(MemberSubmissionAddressingFeature.class)) == null) {
            memberSubmissionAddressingFeature = this.features.get(MemberSubmissionAddressingFeature.class);
        }
        if (memberSubmissionAddressingFeature != null && memberSubmissionAddressingFeature.isEnabled()) {
            bl = true;
        }
        if (bl && this.wsdlService != null && this.wsdlService.get(qName) != null) {
            wSEndpointReference = this.wsdlService.get(qName).getEPR();
        }
        return this.createDispatch(qName, wSEndpointReference, clazz, mode, webServiceFeatureList);
    }

    @Override
    public <T> Dispatch<T> createDispatch(EndpointReference endpointReference, Class<T> clazz, Service.Mode mode, WebServiceFeature ... webServiceFeatureArray) {
        WSEndpointReference wSEndpointReference = new WSEndpointReference(endpointReference);
        QName qName = this.addPortEpr(wSEndpointReference);
        return this.createDispatch(qName, wSEndpointReference, clazz, mode, webServiceFeatureArray);
    }

    @NotNull
    public PortInfo safeGetPort(QName qName) {
        PortInfo portInfo = this.ports.get(qName);
        if (portInfo == null) {
            throw new WebServiceException(ClientMessages.INVALID_PORT_NAME(qName, this.buildNameList(this.ports.keySet())));
        }
        return portInfo;
    }

    private StringBuilder buildNameList(Collection<QName> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (QName qName : collection) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(qName);
        }
        return stringBuilder;
    }

    public EndpointAddress getEndpointAddress(QName qName) {
        PortInfo portInfo = this.ports.get(qName);
        return portInfo != null ? portInfo.targetEndpoint : null;
    }

    @Override
    public Dispatch<Object> createDispatch(QName qName, JAXBContext jAXBContext, Service.Mode mode) throws WebServiceException {
        return this.createDispatch(qName, jAXBContext, mode, EMPTY_FEATURES);
    }

    @Override
    public Dispatch<Object> createDispatch(QName qName, WSEndpointReference wSEndpointReference, JAXBContext jAXBContext, Service.Mode mode, WebServiceFeature ... webServiceFeatureArray) {
        return this.createDispatch(qName, wSEndpointReference, jAXBContext, mode, new WebServiceFeatureList(webServiceFeatureArray));
    }

    protected Dispatch<Object> createDispatch(QName qName, WSEndpointReference wSEndpointReference, JAXBContext jAXBContext, Service.Mode mode, WebServiceFeatureList webServiceFeatureList) {
        PortInfo portInfo = this.safeGetPort(qName);
        ComponentFeature componentFeature = webServiceFeatureList.get(ComponentFeature.class);
        if (componentFeature != null && !ComponentFeature.Target.STUB.equals((Object)componentFeature.getTarget())) {
            throw new IllegalArgumentException();
        }
        ComponentsFeature componentsFeature = webServiceFeatureList.get(ComponentsFeature.class);
        if (componentsFeature != null) {
            for (ComponentFeature object2 : componentsFeature.getComponentFeatures()) {
                if (ComponentFeature.Target.STUB.equals((Object)object2.getTarget())) continue;
                throw new IllegalArgumentException();
            }
        }
        webServiceFeatureList.addAll(this.features);
        BindingImpl bindingImpl = portInfo.createBinding(webServiceFeatureList, null, null);
        bindingImpl.setMode(mode);
        Dispatch<Object> dispatch = Stubs.createJAXBDispatch(portInfo, bindingImpl, jAXBContext, mode, wSEndpointReference);
        this.serviceInterceptor.postCreateDispatch((WSBindingProvider)((Object)dispatch));
        return dispatch;
    }

    @Override
    @NotNull
    public Container getContainer() {
        return this.container;
    }

    @Override
    public Dispatch<Object> createDispatch(QName qName, JAXBContext jAXBContext, Service.Mode mode, WebServiceFeature ... webServiceFeatureArray) {
        return this.createDispatch(qName, jAXBContext, mode, new WebServiceFeatureList(webServiceFeatureArray));
    }

    protected Dispatch<Object> createDispatch(QName qName, JAXBContext jAXBContext, Service.Mode mode, WebServiceFeatureList webServiceFeatureList) {
        MemberSubmissionAddressingFeature memberSubmissionAddressingFeature;
        WSEndpointReference wSEndpointReference = null;
        boolean bl = false;
        AddressingFeature addressingFeature = webServiceFeatureList.get(AddressingFeature.class);
        if (addressingFeature == null) {
            addressingFeature = this.features.get(AddressingFeature.class);
        }
        if (addressingFeature != null && addressingFeature.isEnabled()) {
            bl = true;
        }
        if ((memberSubmissionAddressingFeature = webServiceFeatureList.get(MemberSubmissionAddressingFeature.class)) == null) {
            memberSubmissionAddressingFeature = this.features.get(MemberSubmissionAddressingFeature.class);
        }
        if (memberSubmissionAddressingFeature != null && memberSubmissionAddressingFeature.isEnabled()) {
            bl = true;
        }
        if (bl && this.wsdlService != null && this.wsdlService.get(qName) != null) {
            wSEndpointReference = this.wsdlService.get(qName).getEPR();
        }
        return this.createDispatch(qName, wSEndpointReference, jAXBContext, mode, webServiceFeatureList);
    }

    @Override
    public Dispatch<Object> createDispatch(EndpointReference endpointReference, JAXBContext jAXBContext, Service.Mode mode, WebServiceFeature ... webServiceFeatureArray) {
        WSEndpointReference wSEndpointReference = new WSEndpointReference(endpointReference);
        QName qName = this.addPortEpr(wSEndpointReference);
        return this.createDispatch(qName, wSEndpointReference, jAXBContext, mode, webServiceFeatureArray);
    }

    private QName addPortEpr(WSEndpointReference wSEndpointReference) {
        if (wSEndpointReference == null) {
            throw new WebServiceException(ProviderApiMessages.NULL_EPR());
        }
        QName qName = this.getPortNameFromEPR(wSEndpointReference, null);
        PortInfo portInfo = new PortInfo(this, wSEndpointReference.getAddress() == null ? null : EndpointAddress.create(wSEndpointReference.getAddress()), qName, this.getPortModel(this.wsdlService, qName).getBinding().getBindingId());
        if (!this.ports.containsKey(qName)) {
            this.ports.put(qName, portInfo);
        }
        return qName;
    }

    private QName getPortNameFromEPR(@NotNull WSEndpointReference wSEndpointReference, @Nullable QName qName) {
        QName qName2;
        Object object;
        WSEndpointReference.Metadata metadata = wSEndpointReference.getMetaData();
        QName qName3 = metadata.getServiceName();
        QName qName4 = metadata.getPortName();
        if (qName3 != null && !qName3.equals(this.serviceName)) {
            throw new WebServiceException("EndpointReference WSDL ServiceName differs from Service Instance WSDL Service QName.\n The two Service QNames must match");
        }
        if (this.wsdlService == null) {
            object = metadata.getWsdlSource();
            if (object == null) {
                throw new WebServiceException(ProviderApiMessages.NULL_WSDL());
            }
            try {
                WSDLModel wSDLModel = this.parseWSDL(new URL(wSEndpointReference.getAddress()), (Source)object, null);
                this.wsdlService = wSDLModel.getService(this.serviceName);
                if (this.wsdlService == null) {
                    throw new WebServiceException(ClientMessages.INVALID_SERVICE_NAME(this.serviceName, this.buildNameList(wSDLModel.getServices().keySet())));
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new WebServiceException(ClientMessages.INVALID_ADDRESS(wSEndpointReference.getAddress()));
            }
        }
        if ((qName2 = qName4) == null && qName != null) {
            object = this.wsdlService.getMatchingPort(qName);
            if (object == null) {
                throw new WebServiceException(ClientMessages.UNDEFINED_PORT_TYPE(qName));
            }
            qName2 = object.getName();
        }
        if (qName2 == null) {
            throw new WebServiceException(ProviderApiMessages.NULL_PORTNAME());
        }
        if (this.wsdlService.get(qName2) == null) {
            throw new WebServiceException(ClientMessages.INVALID_EPR_PORT_NAME(qName2, this.buildWsdlPortNames()));
        }
        return qName2;
    }

    private <T> T createProxy(final Class<T> clazz, final InvocationHandler invocationHandler) {
        final ClassLoader classLoader = WSServiceDelegate.getDelegatingLoader(clazz.getClassLoader(), WSServiceDelegate.class.getClassLoader());
        RuntimePermission runtimePermission = new RuntimePermission("accessClassInPackage.com.sun.xml.internal.*");
        PermissionCollection permissionCollection = runtimePermission.newPermissionCollection();
        permissionCollection.add(runtimePermission);
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                Object object = Proxy.newProxyInstance(classLoader, new Class[]{clazz, WSBindingProvider.class, Closeable.class}, invocationHandler);
                return clazz.cast(object);
            }
        }, new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, permissionCollection)}));
    }

    private WSDLService getWSDLModelfromSEI(final Class clazz) {
        WebService webService = AccessController.doPrivileged(new PrivilegedAction<WebService>(){

            @Override
            public WebService run() {
                return clazz.getAnnotation(WebService.class);
            }
        });
        if (webService == null || webService.wsdlLocation().equals("")) {
            return null;
        }
        String string = webService.wsdlLocation();
        string = JAXWSUtils.absolutize(JAXWSUtils.getFileOrURLName(string));
        StreamSource streamSource = new StreamSource(string);
        WSDLService wSDLService = null;
        try {
            URL uRL = streamSource.getSystemId() == null ? null : new URL(streamSource.getSystemId());
            WSDLModel wSDLModel = this.parseWSDL(uRL, streamSource, clazz);
            wSDLService = wSDLModel.getService(this.serviceName);
            if (wSDLService == null) {
                throw new WebServiceException(ClientMessages.INVALID_SERVICE_NAME(this.serviceName, this.buildNameList(wSDLModel.getServices().keySet())));
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new WebServiceException(ClientMessages.INVALID_WSDL_URL(streamSource.getSystemId()));
        }
        return wSDLService;
    }

    @Override
    public QName getServiceName() {
        return this.serviceName;
    }

    public Class getServiceClass() {
        return this.serviceClass;
    }

    @Override
    public Iterator<QName> getPorts() throws WebServiceException {
        return this.ports.keySet().iterator();
    }

    @Override
    public URL getWSDLDocumentLocation() {
        if (this.wsdlService == null) {
            return null;
        }
        try {
            return new URL(this.wsdlService.getParent().getLocation().getSystemId());
        }
        catch (MalformedURLException malformedURLException) {
            throw new AssertionError((Object)malformedURLException);
        }
    }

    private <T> T createEndpointIFBaseProxy(@Nullable WSEndpointReference wSEndpointReference, QName qName, Class<T> clazz, WebServiceFeatureList webServiceFeatureList, SEIPortInfo sEIPortInfo) {
        if (this.wsdlService == null) {
            throw new WebServiceException(ClientMessages.INVALID_SERVICE_NO_WSDL(this.serviceName));
        }
        if (this.wsdlService.get(qName) == null) {
            throw new WebServiceException(ClientMessages.INVALID_PORT_NAME(qName, this.buildWsdlPortNames()));
        }
        BindingImpl bindingImpl = sEIPortInfo.createBinding(webServiceFeatureList, clazz);
        InvocationHandler invocationHandler = this.getStubHandler(bindingImpl, sEIPortInfo, wSEndpointReference);
        T t = this.createProxy(clazz, invocationHandler);
        if (this.serviceInterceptor != null) {
            this.serviceInterceptor.postCreateProxy((WSBindingProvider)t, clazz);
        }
        return t;
    }

    protected InvocationHandler getStubHandler(BindingImpl bindingImpl, SEIPortInfo sEIPortInfo, @Nullable WSEndpointReference wSEndpointReference) {
        return new SEIStub((WSPortInfo)sEIPortInfo, bindingImpl, sEIPortInfo.model, wSEndpointReference);
    }

    private StringBuilder buildWsdlPortNames() {
        HashSet<QName> hashSet = new HashSet<QName>();
        for (WSDLPort wSDLPort : this.wsdlService.getPorts()) {
            hashSet.add(wSDLPort.getName());
        }
        return this.buildNameList(hashSet);
    }

    @NotNull
    public WSDLPort getPortModel(WSDLService wSDLService, QName qName) {
        WSDLPort wSDLPort = wSDLService.get(qName);
        if (wSDLPort == null) {
            throw new WebServiceException(ClientMessages.INVALID_PORT_NAME(qName, this.buildWsdlPortNames()));
        }
        return wSDLPort;
    }

    private SEIPortInfo addSEI(QName qName, Class clazz, WebServiceFeatureList webServiceFeatureList) throws WebServiceException {
        boolean bl = this.useOwnSEIModel(webServiceFeatureList);
        if (bl) {
            return this.createSEIPortInfo(qName, clazz, webServiceFeatureList);
        }
        SEIPortInfo sEIPortInfo = this.seiContext.get(qName);
        if (sEIPortInfo == null) {
            sEIPortInfo = this.createSEIPortInfo(qName, clazz, webServiceFeatureList);
            this.seiContext.put(sEIPortInfo.portName, sEIPortInfo);
            this.ports.put(sEIPortInfo.portName, sEIPortInfo);
        }
        return sEIPortInfo;
    }

    public SEIModel buildRuntimeModel(QName qName, QName qName2, Class clazz, WSDLPort wSDLPort, WebServiceFeatureList webServiceFeatureList) {
        DatabindingFactory databindingFactory = DatabindingFactory.newInstance();
        DatabindingConfig databindingConfig = new DatabindingConfig();
        databindingConfig.setContractClass(clazz);
        databindingConfig.getMappingInfo().setServiceName(qName);
        databindingConfig.setWsdlPort(wSDLPort);
        databindingConfig.setFeatures(webServiceFeatureList);
        databindingConfig.setClassLoader(clazz.getClassLoader());
        databindingConfig.getMappingInfo().setPortName(qName2);
        databindingConfig.setWsdlURL(this.wsdlURL);
        databindingConfig.setMetadataReader(this.getMetadadaReader(webServiceFeatureList, clazz.getClassLoader()));
        DatabindingImpl databindingImpl = (DatabindingImpl)databindingFactory.createRuntime(databindingConfig);
        return databindingImpl.getModel();
    }

    private MetadataReader getMetadadaReader(WebServiceFeatureList webServiceFeatureList, ClassLoader classLoader) {
        if (webServiceFeatureList == null) {
            return null;
        }
        ExternalMetadataFeature externalMetadataFeature = webServiceFeatureList.get(ExternalMetadataFeature.class);
        if (externalMetadataFeature != null) {
            return externalMetadataFeature.getMetadataReader(classLoader, false);
        }
        return null;
    }

    private SEIPortInfo createSEIPortInfo(QName qName, Class clazz, WebServiceFeatureList webServiceFeatureList) {
        WSDLPort wSDLPort = this.getPortModel(this.wsdlService, qName);
        SEIModel sEIModel = this.buildRuntimeModel(this.serviceName, qName, clazz, wSDLPort, webServiceFeatureList);
        return new SEIPortInfo(this, clazz, (SOAPSEIModel)sEIModel, wSDLPort);
    }

    private boolean useOwnSEIModel(WebServiceFeatureList webServiceFeatureList) {
        return webServiceFeatureList.contains(UsesJAXBContextFeature.class);
    }

    public WSDLService getWsdlService() {
        return this.wsdlService;
    }

    private static ClassLoader getDelegatingLoader(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader == null) {
            return classLoader2;
        }
        if (classLoader2 == null) {
            return classLoader;
        }
        return new DelegatingLoader(classLoader, classLoader2);
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(Boolean.TRUE);
            return thread;
        }
    }

    private static final class DelegatingLoader
    extends ClassLoader {
        private final ClassLoader loader;

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + (this.loader == null ? 0 : this.loader.hashCode());
            n2 = 31 * n2 + (this.getParent() == null ? 0 : this.getParent().hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            DelegatingLoader delegatingLoader = (DelegatingLoader)object;
            if (this.loader == null ? delegatingLoader.loader != null : !this.loader.equals(delegatingLoader.loader)) {
                return false;
            }
            return !(this.getParent() == null ? delegatingLoader.getParent() != null : !this.getParent().equals(delegatingLoader.getParent()));
        }

        DelegatingLoader(ClassLoader classLoader, ClassLoader classLoader2) {
            super(classLoader2);
            this.loader = classLoader;
        }

        protected Class findClass(String string) throws ClassNotFoundException {
            return this.loader.loadClass(string);
        }

        @Override
        protected URL findResource(String string) {
            return this.loader.getResource(string);
        }
    }
}

