/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.pipe;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.pipe.ClientPipeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.Pipe;
import com.sun.xml.internal.ws.api.pipe.TransportPipeFactory;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.helper.PipeAdapter;
import com.sun.xml.internal.ws.transport.http.client.HttpTransportPipe;
import com.sun.xml.internal.ws.util.ServiceFinder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.WebServiceException;

public abstract class TransportTubeFactory {
    private static final TransportTubeFactory DEFAULT = new DefaultTransportTubeFactory();
    private static final Logger logger = Logger.getLogger(TransportTubeFactory.class.getName());

    public abstract Tube doCreate(@NotNull ClientTubeAssemblerContext var1);

    public static Tube create(@Nullable ClassLoader classLoader, @NotNull ClientTubeAssemblerContext clientTubeAssemblerContext) {
        for (TransportTubeFactory object : ServiceFinder.find(TransportTubeFactory.class, classLoader, clientTubeAssemblerContext.getContainer())) {
            Tube tube = object.doCreate(clientTubeAssemblerContext);
            if (tube == null) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0} successfully created {1}", new Object[]{object.getClass(), tube});
            }
            return tube;
        }
        ClientPipeAssemblerContext clientPipeAssemblerContext = new ClientPipeAssemblerContext(clientTubeAssemblerContext.getAddress(), clientTubeAssemblerContext.getWsdlModel(), clientTubeAssemblerContext.getService(), clientTubeAssemblerContext.getBinding(), clientTubeAssemblerContext.getContainer());
        clientPipeAssemblerContext.setCodec(clientTubeAssemblerContext.getCodec());
        for (TransportPipeFactory transportPipeFactory : ServiceFinder.find(TransportPipeFactory.class, classLoader)) {
            Pipe pipe = transportPipeFactory.doCreate(clientPipeAssemblerContext);
            if (pipe == null) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "{0} successfully created {1}", new Object[]{transportPipeFactory.getClass(), pipe});
            }
            return PipeAdapter.adapt(pipe);
        }
        return DEFAULT.createDefault(clientPipeAssemblerContext);
    }

    protected Tube createDefault(ClientTubeAssemblerContext clientTubeAssemblerContext) {
        String string = clientTubeAssemblerContext.getAddress().getURI().getScheme();
        if (string != null && (string.equalsIgnoreCase("http") || string.equalsIgnoreCase("https"))) {
            return this.createHttpTransport(clientTubeAssemblerContext);
        }
        throw new WebServiceException("Unsupported endpoint address: " + clientTubeAssemblerContext.getAddress());
    }

    protected Tube createHttpTransport(ClientTubeAssemblerContext clientTubeAssemblerContext) {
        return new HttpTransportPipe(clientTubeAssemblerContext.getCodec(), clientTubeAssemblerContext.getBinding());
    }

    private static class DefaultTransportTubeFactory
    extends TransportTubeFactory {
        private DefaultTransportTubeFactory() {
        }

        @Override
        public Tube doCreate(ClientTubeAssemblerContext clientTubeAssemblerContext) {
            return this.createDefault(clientTubeAssemblerContext);
        }
    }
}

