/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import sun.misc.Contended;
import sun.misc.Unsafe;

public class Exchanger<V> {
    private static final int ASHIFT = 7;
    private static final int MMASK = 255;
    private static final int SEQ = 256;
    private static final int NCPU;
    static final int FULL;
    private static final int SPINS = 1024;
    private static final Object NULL_ITEM;
    private static final Object TIMED_OUT;
    private final Participant participant = new Participant();
    private volatile Node[] arena;
    private volatile Node slot;
    private volatile int bound;
    private static final Unsafe U;
    private static final long BOUND;
    private static final long SLOT;
    private static final long MATCH;
    private static final long BLOCKER;
    private static final int ABASE;

    private final Object arenaExchange(Object object, boolean bl, long l) {
        Node[] nodeArray = this.arena;
        Node node = (Node)this.participant.get();
        int n = node.index;
        while (true) {
            long l2;
            Node node2;
            if ((node2 = (Node)U.getObjectVolatile(nodeArray, l2 = (long)((n << 7) + ABASE))) != null && U.compareAndSwapObject(nodeArray, l2, node2, null)) {
                Object object2 = node2.item;
                node2.match = object;
                Thread thread = node2.parked;
                if (thread != null) {
                    U.unpark(thread);
                }
                return object2;
            }
            int n2 = this.bound;
            int n3 = n2 & 0xFF;
            if (n <= n3 && node2 == null) {
                node.item = object;
                if (U.compareAndSwapObject(nodeArray, l2, null, node)) {
                    long l3 = bl && n3 == 0 ? System.nanoTime() + l : 0L;
                    Thread thread = Thread.currentThread();
                    int n4 = node.hash;
                    int n5 = 1024;
                    while (true) {
                        Object object3;
                        if ((object3 = node.match) != null) {
                            U.putOrderedObject(node, MATCH, null);
                            node.item = null;
                            node.hash = n4;
                            return object3;
                        }
                        if (n5 > 0) {
                            n4 ^= n4 << 1;
                            n4 ^= n4 >>> 3;
                            if ((n4 ^= n4 << 10) == 0) {
                                n4 = 0x400 | (int)thread.getId();
                                continue;
                            }
                            if (n4 >= 0 || (--n5 & 0x1FF) != 0) continue;
                            Thread.yield();
                            continue;
                        }
                        if (U.getObjectVolatile(nodeArray, l2) != node) {
                            n5 = 1024;
                            continue;
                        }
                        if (!(thread.isInterrupted() || n3 != 0 || bl && (l = l3 - System.nanoTime()) <= 0L)) {
                            U.putObject((Object)thread, BLOCKER, (Object)this);
                            node.parked = thread;
                            if (U.getObjectVolatile(nodeArray, l2) == node) {
                                U.park(false, l);
                            }
                            node.parked = null;
                            U.putObject((Object)thread, BLOCKER, null);
                            continue;
                        }
                        if (U.getObjectVolatile(nodeArray, l2) == node && U.compareAndSwapObject(nodeArray, l2, node, null)) break;
                    }
                    if (n3 != 0) {
                        U.compareAndSwapInt(this, BOUND, n2, n2 + 256 - 1);
                    }
                    node.item = null;
                    node.hash = n4;
                    n = node.index >>>= 1;
                    if (Thread.interrupted()) {
                        return null;
                    }
                    if (!bl || n3 != 0 || l > 0L) continue;
                    return TIMED_OUT;
                }
                node.item = null;
                continue;
            }
            if (node.bound != n2) {
                node.bound = n2;
                node.collides = 0;
                n = n != n3 || n3 == 0 ? n3 : n3 - 1;
            } else {
                int n6 = node.collides;
                if (n6 < n3 || n3 == FULL || !U.compareAndSwapInt(this, BOUND, n2, n2 + 256 + 1)) {
                    node.collides = n6 + 1;
                    n = n == 0 ? n3 : n - 1;
                } else {
                    n = n3 + 1;
                }
            }
            node.index = n;
        }
    }

    private final Object slotExchange(Object object, boolean bl, long l) {
        Object object2;
        int n;
        Node node = (Node)this.participant.get();
        Thread thread = Thread.currentThread();
        if (thread.isInterrupted()) {
            return null;
        }
        while (true) {
            Node node2;
            if ((node2 = this.slot) != null) {
                if (U.compareAndSwapObject(this, SLOT, node2, null)) {
                    Object object3 = node2.item;
                    node2.match = object;
                    Thread thread2 = node2.parked;
                    if (thread2 != null) {
                        U.unpark(thread2);
                    }
                    return object3;
                }
                if (NCPU <= 1 || this.bound != 0 || !U.compareAndSwapInt(this, BOUND, 0, 256)) continue;
                this.arena = new Node[FULL + 2 << 7];
                continue;
            }
            if (this.arena != null) {
                return null;
            }
            node.item = object;
            if (U.compareAndSwapObject(this, SLOT, null, node)) break;
            node.item = null;
        }
        int n2 = node.hash;
        long l2 = bl ? System.nanoTime() + l : 0L;
        int n3 = n = NCPU > 1 ? 1024 : 1;
        while ((object2 = node.match) == null) {
            if (n > 0) {
                n2 ^= n2 << 1;
                n2 ^= n2 >>> 3;
                if ((n2 ^= n2 << 10) == 0) {
                    n2 = 0x400 | (int)thread.getId();
                    continue;
                }
                if (n2 >= 0 || (--n & 0x1FF) != 0) continue;
                Thread.yield();
                continue;
            }
            if (this.slot != node) {
                n = 1024;
                continue;
            }
            if (!(thread.isInterrupted() || this.arena != null || bl && (l = l2 - System.nanoTime()) <= 0L)) {
                U.putObject((Object)thread, BLOCKER, (Object)this);
                node.parked = thread;
                if (this.slot == node) {
                    U.park(false, l);
                }
                node.parked = null;
                U.putObject((Object)thread, BLOCKER, null);
                continue;
            }
            if (!U.compareAndSwapObject(this, SLOT, node, null)) continue;
            object2 = bl && l <= 0L && !thread.isInterrupted() ? TIMED_OUT : null;
            break;
        }
        U.putOrderedObject(node, MATCH, null);
        node.item = null;
        node.hash = n2;
        return object2;
    }

    public V exchange(V v) throws InterruptedException {
        Object object;
        Object object2;
        Object object3 = object2 = v == null ? NULL_ITEM : v;
        if (!(this.arena == null && (object = this.slotExchange(object2, false, 0L)) != null || !Thread.interrupted() && (object = this.arenaExchange(object2, false, 0L)) != null)) {
            throw new InterruptedException();
        }
        return (V)(object == NULL_ITEM ? null : object);
    }

    public V exchange(V v, long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        Object object;
        Object object2 = v == null ? NULL_ITEM : v;
        long l2 = timeUnit.toNanos(l);
        if (!(this.arena == null && (object = this.slotExchange(object2, true, l2)) != null || !Thread.interrupted() && (object = this.arenaExchange(object2, true, l2)) != null)) {
            throw new InterruptedException();
        }
        if (object == TIMED_OUT) {
            throw new TimeoutException();
        }
        return (V)(object == NULL_ITEM ? null : object);
    }

    static {
        int n;
        NCPU = Runtime.getRuntime().availableProcessors();
        FULL = NCPU >= 510 ? 255 : NCPU >>> 1;
        NULL_ITEM = new Object();
        TIMED_OUT = new Object();
        try {
            U = Unsafe.getUnsafe();
            Class<Exchanger> clazz = Exchanger.class;
            Class<Node> clazz2 = Node.class;
            Class<Node[]> clazz3 = Node[].class;
            Class<Thread> clazz4 = Thread.class;
            BOUND = U.objectFieldOffset(clazz.getDeclaredField("bound"));
            SLOT = U.objectFieldOffset(clazz.getDeclaredField("slot"));
            MATCH = U.objectFieldOffset(clazz2.getDeclaredField("match"));
            BLOCKER = U.objectFieldOffset(clazz4.getDeclaredField("parkBlocker"));
            n = U.arrayIndexScale(clazz3);
            ABASE = U.arrayBaseOffset(clazz3) + 128;
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        if ((n & n - 1) != 0 || n > 128) {
            throw new Error("Unsupported array scale");
        }
    }

    @Contended
    static final class Node {
        int index;
        int bound;
        int collides;
        int hash;
        Object item;
        volatile Object match;
        volatile Thread parked;

        Node() {
        }
    }

    static final class Participant
    extends ThreadLocal<Node> {
        Participant() {
        }

        @Override
        public Node initialValue() {
            return new Node();
        }
    }
}

